/*------------------------------------------------------------------------------*
 * File Name: Page.h															*
 * Creation: TD 10/01/2001													    *
 * Purpose: Origin C header	for Page class and other related functions			*
 * Copyright (c) OriginLab Corp.2001											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 4/25/2007 QA70-9682 DOING_EXPORT_BASED_ON_PROPER_REQUIRED_SIZE			*
 *	ML 6/27/2007 GETTING_INFO_IF_EXCEL_PAGE										*
 *	ML 8/22/2007 QA70-9170 WKS_EXPORT_COMMON_HOOKUP_WITH_GRAPH_MORE_WORK		*
 *	ML 5/7/2008 QA70-11514 IGNORING_LAYER_BOUNDING_RECT_AND_AXES_WHEN_DETERMINING_COPYPAGE_BOUNDING_RECT_FOR_GRAPH_PAGE
 *	ML 12/24/2008 QA70-12660 P6 DELETING_WHOLE_SHEETS_OPERATION_INTERPLAY		*
 *	Sophy 12/24/2009 QA80-14883 FAIL_TO_GET_PAGE_STATUS_IF_NOT_IN_ACTIVE_FOLDER	*
 *	Kyle 01/28/2010 QA80-15041 WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT	*
 *	RVD 2/2/2010 qa70-15066 OC_CONTEXT_MENU_POSITION							*
 *	Folger 03/18/10 QA81-14514 ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
 *	RVD 10/14/2010 org-1266 SYSTEM_THEME_OVERRIDE_BROKEN_81						*
 *------------------------------------------------------------------------------*/

#ifndef _PAGE_H
#define _PAGE_H
#include <OC_const.h> // consts used in Origin internal functions
#include <Collection.h>
#include <OrgObj.h>

// Comments last updated by GJL on 12/06/2004
/**+
http://ocwiki.originlab.com/index.php?title=Category:PageBase_(class)
*/
class PageBase : public OriginObject
{
public:

	// Comments last updated by GJL on 12/06/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-PageBase
	*/
	PageBase(); // Default constructor for a PageBase object.

	// Comments last updated by GJL on 12/08/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-PageBase
	*/
	PageBase(LPCSTR lpcszName); // Construct a PageBase object using the name of an existing page.

	// Comments last updated by Joseph on 07/30/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-PageBase
	*/
	PageBase(PageBase &page); // Construct a PageBase object using another PageBase object.

	// Comments last updated by GJL on 12/08/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-GetType
	*/
	int GetType(); // Get the page type of a Page object.

	// Comments last updated by GJL on 12/08/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-GetName
	*/
	BOOL GetName(string &strName); // Get the name of a Page object by argument.

#if  _OC_VER < 0x0750
	// Comments last updated by GJL on 12/08/2004
	/**
		Get the name of a Page object by return value.
	Keywords:
		Name; Page Name; Window Name
	Example1:
		int PageBase_GetName_ex2()
		{
			PageBase pb;
			pb = Project.Pages(); // Get the project's active page
			if( pb.IsValid() )
				printf("Active page is named %s\n", pb.GetName());
			else
				printf("Active page is not valid\n");
			return 0;
		}
	Return:
		Returns the name of the page.
	SeeAlso:
		PageBase::Rename
	*/
	string GetName(); // Get the name of a Page object by return value.
#endif //_OC_VER < 0x0750

	// Comments last updated by Iris on 02/13/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-Rename
	*/
	int Rename(LPCSTR lpcszNewName, BOOL bAskIfAlreadyUsed = FALSE, int nOption = PG_RENAME_SHORTNAME); // Rename a Page.

	// Comments last updated by GJL on 12/09/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-Detach
	*/
	BOOL Detach(); // Detach a Page object from an Origin page.
	
	// Comments last updated by GJL on 12/09/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-Label
	*/
	string Label; // Page label.

	// Comments last updated by GJL on 12/09/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-TitleShow
	*/
	int TitleShow; // Show state of page label.

	// Comments last updated by GJL on 12/09/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-SetShow
	*/
	int SetShow(int nNewShow = PAGE_ACTIVATE); // Shows a hidden page or opens a minimized window.

	// Comments last updated by GJL on 12/10/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-GetShow
	*/
	///Sophy 12/24/2009 QA80-14883 FAIL_TO_GET_PAGE_STATUS_IF_NOT_IN_ACTIVE_FOLDER
	//int GetShow(); // Get the show state of the page.
	int GetShow(BOOL bRestrictCheck = FALSE); // Get the show state of the page.
	///end FAIL_TO_GET_PAGE_STATUS_IF_NOT_IN_ACTIVE_FOLDER

	#if  _OC_VER > 0x0703
	// Comments last updated by GJL on 12/10/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-GetWindow
	*/
	Window GetWindow(int nChildID = 0); // Get the Window object associated with a page object.

	// Comments last updated by GJL on 12/10/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-Print
	*/
	BOOL Print(TreeNode& tn); // Print the page.

	#endif // _OC_VER > 0x0703
	
	// Comments last updated by GJL on 12/10/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-GetFolder
	*/
	Folder GetFolder(); // Get the Project Explorer folder where the page is located.

	#if  _OC_VER >= 0x0750
	// Comments last updated by Iris on 02/13/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-GetPageSystemInfo
	*/
	BOOL GetPageSystemInfo(PageSystemInfo *pInfo); // Get page system information.

	// Comments last updated by GJL on 12/13/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-SaveToFile
	*/
	BOOL SaveToFile(LPCSTR lpcszPathName); // Saves the page to a file.
	#endif //_OC_VER >= 0x0750

	#if _OC_VER >= 0x0800

	///DSC 8/4/06 QA70-8883 SAVE_TEMPLATE_FROM_ORIGINC
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-SaveTemplate
	*/
	BOOL SaveTemplate(LPCSTR lpcszFile, LPCSTR lpcszBmpFile=NULL, LPCSTR lpcszEMFFile=NULL, LPCSTR lpcszDesc=NULL, DWORD dwCtrl=0x0);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-SaveBitmap
	*/
	BOOL SaveBitmap(LPCSTR lpcszBmpFile, int nBmpSize = 200);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-SaveEMF
	*/
	BOOL SaveEMF(LPCSTR lpcszEMFFile);

	///end SAVE_TEMPLATE_FROM_ORIGINC
	#endif // _OC_VER >= 0x0800


	#if _OC_VER >= 0x0800
	// Comments last updated by GJL on 12/13/2004
	/**$
		Set splitters in the window based on the supplied configuration string.
	Keywords:
		Splitter; Window Splitter
	Example1:
		#define STR_WKBOOK_SPLITTER "WkbookSplitter" // Use system definition - included here for ease of Ex only 	
		// Requires active worksheet page
		int PageBase_SetSplitters_ex1(BOOL bShow = TRUE)
		{
			WorksheetPage wp = Project.Pages(0);
			if( wp.IsValid() )
			{
				if( bShow )
				{
					string strConfig = "r{50%}r[" + STR_WKBOOK_SPLITTER + "]";
					wp.SetSplitters(strConfig);
				}
				else
					wp.SetSplitters(NULL);
			}
			return 0;
		}
	Parameters:
		lpcszString=[input]Configuration string including splitter size proportion and the Origin C class name
					of the splitter child window or NULL to remove existing splitter.
	Return:
		Returns TRUE on success and FALSE on failure.
	SeeAlso:
		PageBase::GetSplitterInfo
	*/
	BOOL SetSplitters(LPCSTR lpcszString); // Set splitter in the window.

	// Comments last updated by GJL on 12/13/2004
	/**$
		Retrieve configuration information for the current splitter.
	Keywords:
		Splitter; Window Splitter
	Example1:
		#define STR_WKBOOK_SPLITTER "WkbookSplitter" // Use system definition - included here for ease of Ex only 
		// Requires active worksheet page with Workbook Organizer visible
		int PageBase_GetSplitterInfo_ex1()
		{
			WorksheetPage wp = Project.Pages(0);
			if( wp.IsValid() )
			{
				Tree tr;
				wp.GetSplitterInfo(STR_WKBOOK_SPLITTER, tr);
				out_tree(tr);
				wp.SetSplitters(NULL); // Close splitter
				wp.GetSplitterInfo(STR_WKBOOK_SPLITTER, tr);
				out_tree(tr);
			}
			return 0;
		}
	Parameters:
		lpcszClassName=[input]Origin C class name of existing splitter child window or NULL to return
						information on whether any splitters are present.
		tr=[output]If splitters were found according to the first argument tr receives the serialized
						splitters configuration information.
	Return:
		Returns TRUE if splitters are present according to the first argument otherwise returns FALSE.
	*/
	BOOL GetSplitterInfo(LPCSTR lpcszClassName = NULL, TreeNode &tr = NULL); // Retrieve configuration information for the current splitter.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-GetEmbeddingInfo
	*/
	BOOL GetEmbeddingInfo(Datasheet& parentSheet = NULL, int *pnRow = NULL, int *pnCol = NULL, DWORD *pdw = NULL);

	// Comments last updated by Iris on 02/13/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-IsInManager
	*/
	BOOL IsInManager();
	#endif //_OC_VER >= 0x0800

#if _OC_VER >= 0x0810
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-GetOrder
	*/
	int		GetOrder(Folder *pFolder = NULL);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-SetOrder
	*/
	BOOL	SetOrder(int nOrder, Folder *pFolder = NULL);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PageBase-GetStatus
	*/
	DWORD	GetStatus(Folder& fld = NULL, int* pnCurrentIndexInFolder = NULL);
#endif // _OC_VER >= 0x0810

};

// Comments last updated by GJL on 12/13/2004
/**+
http://ocwiki.originlab.com/index.php?title=Category:Page_(class)
*/
class Page : public PageBase
{
public:

	// Comments last updated by GJL on 12/14/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-Page
	*/
	Page(); // Default constructor for a Page object.

	// Comments last updated by GJL on 12/14/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-Page
	*/
	Page(LPCSTR lpcszName); // Construct a Page object using the name of an existing page.

	// Comments last updated by GJL on 12/14/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-Page
	*/
	Page(PageBase &page); // Construct a Page object using another Page object.

	// Comments last updated by Kenny on 08/26/2009
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-Create
	*/
	/// Kenny 08/26/2009 QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
	//BOOL Create(LPCSTR lpcszTemplate = NULL, int iOption = CREATE_VISIBLE | CREATE_KEEP_LAYER_NAMES); // Create a new page using the supplied template.
	BOOL Create(LPCSTR lpcszTemplate = NULL, int iOption = CREATE_DEFAULT_OPTIONS); // Create a new page using the supplied template.
	/// End QA81-14203 RESET_PAGE_NAME_IF_CREATED_FROM_OC
 
	// Comments last updated by GJL on 12/15/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-Layers
	*/
	Collection<Layer> Layers; // A Collection of all Layers in a page.

	// Comments last updated by GJL on 12/15/2004
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Get a Layer object by index from the Layers Collection.
	Keywords:
		Layer;
	Example1:
		// For this example to run a Graph window must be the active window
		// in the project.
		int Page_Layers_ex2()
		{
			GraphPage gp = Project.Pages();
			if( gp )
			{
				GraphLayer gl = gp.Layers(); // Get active layer
				printf("%s has %d layer(s) with active layer %d\n", gp.GetName(), gp.Layers.Count(), gl.GetIndex() + 1); // Show LabTalk index
			}
			return 0;
		}
	Parameters: 
		iIndex=[input]The index of the requested Layer. If < 0 (default) then the active layer is returned.
	Return:
		Returns a valid Layer object if iIndex is less than the number of layers in the Page otherwise returns an invalid Layer object.
	*/
	Layer Layers(int iIndex = -1); // Get a Layer object by index from the Layers Collection.
	
	// Comments last updated by GJL on 12/21/2004
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Get a layer object by name from the Layers Collection.
	Keywords:
		Layer;
	Example1:
		int Page_Layers_ex3()
		{
			WorksheetPage wp;
			wp.Create("origin");
			if( wp )
			{
				wp.AddLayer();
				wp.AddLayer();
				Worksheet wks1 = wp.Layers(1); // Get second Worksheet by index
				if( wks1 )
				{
					Worksheet wks2 = wp.Layers(wks1.GetName()); // Get same (second) sheet by name
					if( wks2 )
						printf("%s has %d layers with second sheet(layer) named %s\n", wp.GetName(), wp.Layers.Count(), wks2.GetName());
				}
			}
			return 0;
		}
	Parameters: 
		lpcszName=[input]The name of the requested Layer.
	Return:
		Returns the named Layer object on successful exit and an invalid layer object on failure.
	*/	
	Layer Layers(LPCSTR lpcszName); // Get a layer object by name from the Layers Collection. 

	// Comments last updated by GJL on 12/21/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-LT_execute
	*/
	BOOL LT_execute(LPCSTR lpcszScript, int wCtrl = 0); // Execute a LabTalk script temporarily setting this page as the active page.

	// Comments last updated by GJL on 12/21/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-Refresh
	*/
	void Refresh(BOOL bRedraw = FALSE); // Refresh the page.

#if  _OC_VER >= 0x0800
// Comments last updated by Iris on 02/13/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Page-AddLayer
*/
	int	AddLayer(LPCSTR lpcszLayerName = NULL, DWORD dwOptions = 0, LPCSTR lpcszTemplate = NULL, DWORD dwOption2 = 0, LPCSTR lpcszSheet = NULL);

	// Comments last updated by jasmine on 07/18/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-AddLayer
	*/
	int	AddLayer(Layer &layerToCopy, DWORD dwOptions = DCTRL_COPY_DEFAULT, BOOL bKeepSrcLayer = true, int nNewLayerPos = -1);

	//CPY 4/12/08 QA70-11413 DRAG_SHEET_OUT_FROM_BOOK_NEED_OC_ACCESS added bKeepSrcLayer
	

	
	// Comments last updated by Iris on 02/13/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-AddLayers
	*/
	BOOL	AddLayers(Page &pageToCopyFrom);
	
	
	// Comments last updated by Frank on 08/04/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-FindCursors
	*/
	int FindCursors(vector<int>& vnLayers, vector<uint>& vnPlots = NULL, vector<uint>& vnDataIndices = NULL);


	// Comments last updated by Iris on 02/15/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-Clone
	*/
	Page Clone(DWORD dwCntrl = 0);

	// Comments last updated by Iris on 02/15/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-Reorder
	*/
	BOOL Reorder(int nDst, int nSrc = -1, DWORD dwCtrl = 0);

	/// RVD 2/2/2010 qa70-15066 OC_CONTEXT_MENU_POSITION
	/**$
			Convert logical to device points.
		Parameters:
			nx=[input][output] X position.
			ny=[input][output] Y position.
		Return: 
			0 if succeed
	*/
	int		LPtoDP(int& nx, int& ny);
	/**$
			Convert device to logical points.
		Parameters:
			nx=[input][output] X position.
			ny=[input][output] Y position.
		Return: 
			0 if succeed
	*/
	int		DPtoLP(int& nx, int& ny);
	/// end OC_CONTEXT_MENU_POSITION

	/// ML 8/22/2007 QA70-9170 WKS_EXPORT_COMMON_HOOKUP_WITH_GRAPH_MORE_WORK
	/**$
			It computes the ratio for export, given the needed width or height in inches and the current export settings.
		Example1:
			void	test_ComputeNeededExportRatio(double rWidthInches = 10.6, BOOL bReqWidth = 1)
			{
				OriginSettings				os;
				GraphPage					gpg = Project.Pages(-1);
				if (!gpg)
				{
					out_str("Invalid active page.");
					return;
				}
				
				double						rRatio;
				RECT						rectLogical;
				BOOL						b = gpg.ComputeNeededExportRatio(&rRatio, rWidthInches, bReqWidth, &rectLogical);
				printf("%d\t%lf\n", b, rRatio);
			}

		Parameters:
			pRatio=[output]*pRatio receives the required ratio as the Ratio from the Page tab on Options dlg
						divided by 100.
			rRequiredWidthOrHeightInInches=[input]required width or height iin inches.
			bReqWidth=[input]if TRUE, rRequiredWidthOrHeightInInches is width, otherwise it is height.
			prRectLogical=[output,optional]it receives the internal computed rectangle in logical coordinates.
		Return: 
			TRUE if succeed; FALSE otherwise
	*/
	BOOL	ComputeNeededExportRatio(double *pRatio, double rRequiredWidthOrHeightInInches, BOOL bReqWidth, RECT *prRectLogical = NULL);
	/// end WKS_EXPORT_COMMON_HOOKUP_WITH_GRAPH_MORE_WORK

	// Comments last updated by Iris on 02/15/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-SetFlag
	*/
	void SetFlag(DWORD dwBit, BOOL bSet = true);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-TestFlag
	*/
	BOOL TestFlag(DWORD dwBit);
	
	// Comments last updated by Iris on 02/15/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Page-GetSelectedLayers
	*/
	int GetSelectedLayers(vector<int>& vnIndices, vector<string>& vsNames=NULL);

	/// RVD 10/14/2010 org-1266 SYSTEM_THEME_OVERRIDE_BROKEN_81
	/**+
		Same as LabTalk PAGE.CNTRL property
	*/
	DWORD		Cntrl;
	/// end SYSTEM_THEME_OVERRIDE_BROKEN_81

#endif //  _OC_VER >= 0x0800

};

// Comments last updated by GJL on 12/22/2004
/**+
http://ocwiki.originlab.com/index.php?title=Category:MatrixPage_(class)
*/
class MatrixPage : public Page
{
public:
	// Comments last updated by GJL on 12/22/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixPage-MatrixPage
	*/
	MatrixPage(LPCTSTR lpcszName); // Construct a MatrixPage object using the name of an existing matrix page.

	// Comments last updated by GJL on 12/22/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixPage-MatrixPage
	*/
	MatrixPage(PageBase &page); // Construct a MatrixPage object using an existing matrix page object.

	// Comments last updated by EJP on 2006-04-17
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixPage-SetViewMode
	*/
	BOOL SetViewMode(BOOL bViewImage, BOOL bSetAllLayers = FALSE, int nLayerIndex = -1);
	
	///Sophy 6/11/2010 ORG-292 ADD_SHOW_IMAGE_THUMBNAIL_CHECKBOX
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:MatrixPage-ShowImageThumbnails
	*/
	BOOL ShowImageThumbnails(BOOL bShow);
	///end ADD_SHOW_IMAGE_THUMBNAIL_CHECKBOX
};


#if _OC_VER >= 0x0800
/**+
http://ocwiki.originlab.com/index.php?title=Category:GraphPageBase_(class)
*/
class GraphPageBase : public Page
{
public:

	// Comments last updated by GJL on 12/27/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPageBase-GraphPageBase
	*/
	GraphPageBase(LPCTSTR lpcszName); // Construct a GraphPage object using the name of an existing page.

	// Comments last updated by GJL on 12/27/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPageBase-GraphPageBase
	*/
	GraphPageBase(PageBase &page); // Construct a GraphPage object using an existing GraphPage object.

	// Comments last updated by GJL on 12/28/2004, Need a simple example and definition for nOptions from a developer.
	/**#
		Create an image from the graph and directly return the bitmap or metafile handle.
	Keywords:
		Image, create;Image, export;
	Example1:

	Parameters: 
		nCFformat=[input]Image format, one of CF_BITMAP, CF_METAFILEPICT, CF_ENHMETAFILE, CF_DIB
		nDPI=[input]Image resolution or Dots Per Inch.
		nOptions=[input]Image options.
	Return:
		Returns a valid handle on successful exit and NULL on failure. 
	*/
	HANDLE CreateImage(int nCFformat, int nDPI, uint nOptions); // Create an image from the graph and directly return the bitmap or metafile handle.
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPageBase-GetPicture
	*/
	bool GetPicture(PictureHolder &phDest, LPCSTR lpcszType, int nRes, int nSpark, DWORD dwOptions);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPageBase-CreateCopy
	*/
	BOOL	CreateCopy(GraphPageBase &pgDest, DWORD dwCtrl = 0);

};

#endif // _OC_VER >= 0x0800

// Comments last updated by GJL on 12/22/2004
/**+
http://ocwiki.originlab.com/index.php?title=Category:GraphPage_(class)
*/
class GraphPage : public GraphPageBase
{
public:

	// Comments last updated by GJL on 12/27/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPage-GraphPage
	*/
	GraphPage(LPCTSTR lpcszName); // Construct a GraphPage object using the name of an existing page.

	// Comments last updated by GJL on 12/27/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPage-GraphPage
	*/
	GraphPage(PageBase &page); // Construct a GraphPage object using an existing GraphPage object.
	
public:

	// Comments last updated by GJL on 12/27/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPage-RemoveTemplatePict
	*/
	BOOL RemoveTemplatePict(); // Remove template preview image from GraphPage.

	// Comments last updated by GJL on 12/27/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPage-AppendLayers
	*/
	BOOL AppendLayers(LPCSTR lpcszName); // Append layers from the specified template to the page.

	// Comments last updated by GJL on 12/27/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPage-LoadTemplate
	*/
	BOOL LoadTemplate(LPCSTR lpcszName); // Load a template into the page removing any existing layers.



	// Comments last updated by GJL on 12/28/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPage-Layers
	*/
	Collection<GraphLayer> Layers; // A Collection of all GraphLayers in a GraphPage.

	// Comments last updated by GJL on 12/28/2004
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Get a GraphLayer object by index.
	Keywords:
		Layer; GraphLayer
	Example1:
		// For this example to run, a graph window must exist
		// in the project.
		int GraphPage_Layers_ex2()
		{
			GraphPage gp = Project.GraphPages(0);
			if( gp.IsValid() )
			{
				GraphLayer gl = gp.Layers(); // Get active layer
				if( gl.IsValid() )
					printf("GraphLayer %s is active\n", gl.GetName());
			}
			return 0;
		}
	Parameters: 
		iIndex=[input]The index (0 offset) of the requested Layer. If iIndex < 0 then
			the active Layer is returned.
	Return:
		Returns a valid GraphLayer object on successful exit and an invalid GraphLayer object on failure.
	*/	
	GraphLayer Layers(int iIndex = -1); // Get a GraphLayer object by index.
	
	// Comments last updated by GJL on 12/28/2004
	// Comments last updated by Sim on 08-01-2008 same name as property, not add to doc for SR3
	/**$
		Get a GraphLayer object by name.
	Keywords:
		Layer; GraphLayer
	Example1:
		int GraphPage_Layers_ex3(string strLayerName = "Test")
		{
			GraphPage gp;
			gp.Create("origin");
			if( gp.IsValid() )
			{
				gp.AddLayer("Test");
				gp.AddLayer("Test");
				GraphLayer gl = gp.Layers(strLayerName);
				if( gl.IsValid() )
					printf("The layer %s exists.\n", strLayerName);
				else
					printf("The layer %s does not exist.\n", strLayerName);
			}
			return 0;
		}
	Parameters: 
		lpcszName=[input]The name of the requested layer
	Return:
		Returns a valid GraphLayer object on successful exit and an invalid GraphLayer object on failure.
	*/	
	GraphLayer Layers(LPCSTR lpcszName); // Get a GraphLayer object by name.

	// Comments last updated by Iris on 02/15/2008
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPage-AxisLayerIcons
	*/
	BOOL		AxisLayerIcons;

	/// ML 5/7/2008 QA70-11514 IGNORING_LAYER_BOUNDING_RECT_AND_AXES_WHEN_DETERMINING_COPYPAGE_BOUNDING_RECT_FOR_GRAPH_PAGE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:GraphPage-ForceNoLayerBoundsAxesForTightRect
	*/
	BOOL		ForceNoLayerBoundsAxesForTightRect;
	/// end IGNORING_LAYER_BOUNDING_RECT_AND_AXES_WHEN_DETERMINING_COPYPAGE_BOUNDING_RECT_FOR_GRAPH_PAGE

	///Kyle 01/28/2010 QA80-15041 WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT
	BOOL		SetUseSpeedModeForExport(BOOL bSet);
	BOOL		IsUseSpeedModeForExport();
	///End WANT_ENABLE_GRAPH_CURRENT_SPEED_MODE_FOR_EXPORT
	/// TD ML 05-04-2010 ORG-74 POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT
	/**$
		Searches for the plot index of the next function plot.
	Keywords:
		Layer; GraphLayer
	Parameters: 
		pnDataPlotIndex	=[input, output] the value passed in is used as start DataPlot index for the search, and is set to the found index when successful
		pnLayerIndex	=[input, output] the value passed in is used as start Layer index for the search, and is set to the found index when successful
	Return:
		Returns non zero when the search is successful, otherwise zero
	*/	
	BOOL		GetNextFunctionPlotIndex(int *pnDataPlotIndex = NULL, int *pnLayerIndex = NULL);
	/// end POLAR_AND_FUNCTION_DIALOGBAR_IMPROVEMENT

};

// Comments last updated by GJL on 12/28/2004
/**+
http://ocwiki.originlab.com/index.php?title=Category:LayoutPage_(class)
*/
class LayoutPage : public GraphPageBase
{
public:
	// Comments last updated by GJL on 12/28/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:LayoutPage-LayoutPage
	*/
	LayoutPage(LPCTSTR lpcszName); // Construct a LayoutPage object using the name of an existing Origin layout page.

	// Comments last updated by GJL on 12/28/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:LayoutPage-LayoutPage
	*/
	LayoutPage(PageBase &page); // Construct a LayoutPage object using an existing LayoutPage object.
};

// Comments last updated by GJL on 12/28/2004
/**+
http://ocwiki.originlab.com/index.php?title=Category:WorksheetPage_(class)
*/
class WorksheetPage : public Page
{
public:
	// Comments last updated by GJL on 12/28/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-WorksheetPage
	*/
	WorksheetPage(LPCTSTR lpcszName); // Construct a WorksheetPage object using the name of an existing Origin worksheet page.

	// Comments last updated by GJL on 12/28/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-WorksheetPage
	*/
	WorksheetPage(PageBase &page); // Construct a WorksheetPage object using an existing WorksheetPage object.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-OpenExcel
	*/
	int OpenExcel(int nMode, LPCSTR lpcszxlsFile, LPCSTR lpcszSheet = NULL, DWORD dwCntrl = 0, int nMaxNumEmptyColumnsBeyondLastData = 0);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-OpenExcel
	*/
	int OpenExcel(int nMode, LPCSTR lpcszxlsFile, int nSheetIndex, DWORD dwCntrl = 0, int nMaxNumEmptyColumnsBeyondLastData = 0);

	// Comments last updated by Joseph on 07/30/2007, this function needs to be updated for new workbook
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-OpenExcel
	*/
	BOOL OpenExcel(LPCSTR lpcszWorkbookFile, LPCSTR lpcszSheetName = NULL); // Open an Excel *.XLS file as either an Excel workbook or as an Origin worksheet.

	// Comments last updated by GJL on 12/29/2004, this function needs to be updated for new workbook
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-OpenExcel
	*/
	BOOL OpenExcel(LPCSTR lpcszWorkbookFile, int nSheetIndex = -1);
	
	// Comments last updated by GJL on 12/29/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-ExcelSheet
	*/
	BOOL ExcelSheet(LPCSTR lpcszSheetName, int nColsNeeded = 0); // Connects to the Excel sheet named lpcszSheetName.
	
	// Comments last updated by GJL on 12/29/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-ExcelSheet
	*/
	string ExcelSheet(int nSheetNumber, int nColsNeeded = 0); // Connects to the Excel sheet having the index nSheetNumber.
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-SaveExcelInOpj
	*/
	BOOL SaveExcelInOpj(BOOL bSave = TRUE, BOOL bAutoUpdate = TRUE);

	// Comments last updated by Joseph on 07/30/2007
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-GetExcelCOMObject
	*/
	BOOL	GetExcelCOMObject(Object &obj);

	/// ML 12/24/2008 QA70-12660 P6 DELETING_WHOLE_SHEETS_OPERATION_INTERPLAY
	/**$
			It checks and or deletes operations whose inputs or outputs are in the layers supplied.
		Parameters:
			mode=[inout] one of the following values:
				WKBKDELWKSMODE_DEFAULT		- does nothing
				WKBKDELWKSMODE_CHECK_ASK	- it should first time be called with this value. It checks
												if there are any operations that need to be removed (but
												does not removed them). If needed, user will be prompted
												for approval, in which case the function will return < 0
												if user cancelled, or > 0 if user approved. If user approves
												output data removal, mode will on return be set to
												WKBKDELWKSMODE_DELETE_OPERS_DATA, otherwise to
												WKBKDELWKSMODE_DELETE_OPERS. mode will also be set to
												WKBKDELWKSMODE_DELETE_OPERS on return if the function returns 0,
												but there are operations that need to be removed, which then gives
												the caller a chance to prompt user for reasons unrelated to operations.
				WKBKDELWKSMODE_DELETE_OPERS_DATA - put all the layers that need to be removed into parrLayerIndices
												(provided they are not already there) and also removed the operations
												as needed. No prompting of user.
				WKBKDELWKSMODE_DELETE_OPERS		- just remove all operations as needed. No prompting of user.
												
			
	*/
	int		CheckOperationsDelete(WKBKDELWKSMODE &mode, vector<int> *parrLayerIndices, BOOL *pbUndoably);
	/// end DELETING_WHOLE_SHEETS_OPERATION_INTERPLAY

	///------ Folger 03/18/10 QA81-14514 ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP
	/**$
		Update Excel page to Origin
	Parameters:
		dwCntrl=[input]Control bits, WKSPAGEUPDATEORIGIN_*
	*/
	BOOL	UpdateOrigin(DWORD dwCntrl = 0);
	///------ End ALL_SHEETS_IN_EXCEL_BOOK_SHOULD_BE_SHOWN_IN_PLOT_SETUP

	/// ML 6/27/2007 GETTING_INFO_IF_EXCEL_PAGE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:WorksheetPage-m_bIsExcel
	*/
	BOOL	m_bIsExcel;
	/// end GETTING_INFO_IF_EXCEL_PAGE

};

// Comments last updated by GJL on 12/07/2004
/**+
http://ocwiki.originlab.com/index.php?title=Category:Note_(class)
*/
class Note : public PageBase
{
public:
	// Comments last updated by GJL on 12/29/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Note-Note
	*/
	Note(LPCTSTR lpcszName); // Construct a Note object using the name of an existing Origin Note page.

	// Comments last updated by GJL on 12/29/2004
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Note-Note
	*/
	Note(PageBase &page); // Construct a Note object using an existing Origin C Note (PageBase) object.

	// Comments last updated by GJL on 01/03/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Note-Create
	*/
	BOOL Create(int nOption = CREATE_VISIBLE, LPCSTR lpcszFilePathName = NULL); // Create a new Notes window.

	// Comments last updated by GJL on 01/03/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Note-Text
	*/
	string Text; // String data member containing the text of the Notes window.
};

///Comments last updated by Iris on 07/31/2008, added #
/**# >Internal Origin Objects
*/
class NagViewPage : public PageBase
{
public:
	/**
		contructor, uses window name to attach to a DialogPage

	Parameters:
		lpcszWindowName=[input]name of the page to attach to

	*/
	NagViewPage(LPCSTR lpcszWindowName);
	/**
		copy contructor

	Parameters:
		DlgPage=[input]page to copy from 

	*/
	NagViewPage(PageBase &page);
	/**
		Creates an actula page object and the corresponding window etc

	Parameters:
		nOption= Standard Origin window create options including
					CREATE_VISIBLE - creates a visible Notes page (window)
					CREATE_HIDDEN - creates a hidden Notes page
	Return:
		return TRUE is successful else false.

	*/
	BOOL Create(int nOption);
};


#endif //_PAGE_H
